'*******************************************************************************************************
'*
'* Author......: Chiatto Raffaele
'* 
'* WebSite.....: http://www.chiattoraffaele.it
'*
'* E-Mail......: raffaele.chiatto@gmail.com
'*
'* Scopo.............: Deploy dell'indirizzo SMTP primario nel namespace "@forestaA.com"
'*                     degli utenti della forest "forestaB.it"
'*
'* Come opera........: L'elenco degli users su cui bidogna intervenire  fornito dalla gestione
'*                     della foresta forestaB.
'*
'*                     Questo elenco viene processato una prima ottenendo un 
'*                     file di input per "DeploySMTP.vbs".
'*                     Questo primo processo serve per verificare eventuali omonimie
'*                     presenti tra gli utenti della forestaA forestaB interessati dalla operazione.
'*                     Il file di input per questo script viene fornito a corredo.
'*
'*                     Al termine delle operazioni lo script produce un file "csv"
'*                     (con separatore ";") facilmente apribile con Excel, che contiene
'*                     le informazioni di riepilogo delle operazioni svolte.
'*                     Il file csv evidenzia i casi di omonimia indicando l'ID della
'*                     riga che contiene i dati che l'hanno generata.
'*
'*******************************************************************************************************



'==================================================
'=            INIZIO CONFIGURAZIONE               =
'==================================================
  
DomainController="domain.forestaB.it"                   'il nome "flat" del DC sul Dc di riferimento.

DomainFQDN="forestaB.it"                          	'Il FQDN del dominio su cui si opera

OutputFileName="SMTPset.csv"                      	'Il file csv con il resoconto delle operazioni

InputFileName="DeploySMTP_Input.csv"             	'Il file di input, gi configurato con il nome del file fornito.


'==================================================
'=              FINE CONFIGURAZIONE               =
'= non modificare nulla al disotto di questa riga =
'==================================================



DomainRoot=RetriveLDAPFormat(DomainFQDN)

Set oFSO= CreateObject("Scripting.FileSystemObject")
Set oInputFileName=oFSO.OpenTextFile(InputFileName,1,false)
ldapDomainRoot="LDAP://" & DomainController & "/" & DomainRoot
Dim arrTable()
Dim arrTableLine
arrTableLine=-1


Set objConnection = CreateObject("ADODB.Connection")
Set objCommandOU = CreateObject("ADODB.Command")
Set objCommandList = CreateObject("ADODB.Command")
objConnection.Provider = "ADsDSOObject"
objConnection.Open "Active Directory Provider"

Set objCommandOU.ActiveConnection = objConnection
objCommandOU.Properties("Page Size") = 1000
objCommandOU.Properties("Timeout") = 30 
objCommandOU.Properties("Cache Results") = False
objCommandOU.Properties("Searchscope") = 2



Do Until oInputFileName.AtEndOfStream
   ToroLine=oInputFileName.ReadLine
   ToroLineFields=Split(ToroLine,";")
   
   arrTableLine=arrTableLine+1
   ReDim Preserve arrTable(12,arrTableLine)
   arrTable(0,arrTableLine)=ToroLineFields(0)
   arrTable(1,arrTableLine)=ToroLineFields(1)
   arrTable(2,arrTableLine)=ToroLineFields(2)
   arrTable(3,arrTableLine)=ToroLineFields(3)
   arrTable(4,arrTableLine)=ToroLineFields(4)
   arrTable(5,arrTableLine)=ToroLineFields(5)
   arrTable(6,arrTableLine)=ToroLineFields(6)
   arrTable(7,arrTableLine)=ToroLineFields(7)
   arrTable(8,arrTableLine)=ToroLineFields(8)
   arrTable(9,arrTableLine)=ToroLineFields(9)

'campi relativi all'ExtensionAttribute1, necessari solo per corpgen
'   arrTable(10,arrTableLine)=ToroLineFields(10)
'   arrTable(11,arrTableLine)=ToroLineFields(11)

   GetADUserInfo arrTable(5,arrTableLine),arrTableLine

   NewPrimarySMTPAddress="SMTP:" & arrTable(9,arrTableLine)

   If arrTable(8,arrTableLine)="no" then
      UpdateSMTPAddress arrTable(2,arrTableLine),NewPrimarySMTPAddress
   end if
loop



'Verifica esito operazione
'-------------------------
for q=0 to ubound(arrTable,2)
   VerifySettings arrTable(2,q),q
next

WriteLog

MSGBOX "OPERAZIONI TERMINATE" & vbcrlf & vbcrlf & "L'esito  riportato nel file " & OutputFileName & ".", +VBInformation,"SMTP: @forestaA.com"










'=========================
'= MODIFICA INDIRIZZI SMTP
'=========================
Sub UpdateSMTPAddress(distname,sAddress)
   Set oUser = GetObject ("LDAP://" & DomainController & "/" & distname)
   Set objRecip = oUser
   arrAddresses = objRecip.ProxyAddresses
   AddressNum=UBound(arrAddresses)
      
   AlreadyPresentAddress=-1
   For q=0 To AddressNum
      If lcase(arrAddresses(q)) = lcase(sAddress)  Then
            AlreadyPresentAddress=q
      End If
        
      If Left(LCase(arrAddresses(q)),5)="smtp:" Then
         arrAddresses(q)=LCase(arrAddresses(q))
      End If
   Next

   If AlreadyPresentAddress=-1 Then
      NewArrLine=UBound(arrAddresses) + 1
      ReDim Preserve arrAddresses(NewArrLine)
      arrAddresses(NewArrLine) = sAddress
      oUser.Put "mail",Mid(sAddress,6)
   Else
      arrAddresses(AlreadyPresentAddress)="SMTP:" & Mid(arrAddresses(AlreadyPresentAddress),6)
      oUser.Put "mail",Mid(arrAddresses(AlreadyPresentAddress),6)
   End If

   objRecip.ProxyAddresses = arrAddresses
   oUser.SetInfo
End sub



'=======================
'= Ricava info AD user =
'=======================
Function GetADUserInfo(PrimarySMTP,tableline)
   on error resume next
   objCommandOU.CommandText = "Select mail,SamAccountName,DistinguishedName from '" & ldapDomainRoot &"' WHERE mail='" & PrimarySMTP & "'"
   Set objRecordSetOU = objCommandOU.Execute
   err.clear
   objRecordSetOU.MoveFirst
   if NOT err.number = 0 then
      arrTable(2,tableline)="err"
      arrTable(6,tableline)="err"
      arrTable(8,tableline)="err"
      arrTable(9,tableline)="err"
      arrTable(12,tableline)="err"
   else
      arrTable(2,tableline)=objRecordSetOU.Fields("DistinguishedName").Value
      arrTable(6,TableLine)=objRecordSetOU.Fields("SamAccountName").value
   end if
End Function



'======================
'= Verifica risultati =
'======================
Function VerifySettings(UserDN,tableline)
   If arrTable(8,TableLine)="no" then
      Set oCurrUser=GetObject("LDAP://" & DomainController & "/" & userdn)
      if oCurrUser.mail = arrTable(9,TableLine) then
         arrTable(12,TableLine)="OK"
      else
         arrTable(12,TableLine)="KO"
      end if
   else
      arrTable(12,TableLine)="-"
   end if
end function   



'=================
'= Scrive il log =
'=================
Function WriteLog
   Set oLogFile=oFSO.OpenTextFile(OutputFileName,2,true)
   Header="LineID;Cognome;Nome;Old SMTP;Duplicato;New SMTP;Check"
   oLogFile.WriteLine Header
   for q=0 to uBound(arrTable,2)
      outline=arrTable(0,q)
      for w=3 to ubound(arrTable,1)
         if w<>6 AND W<>7 AND w<>10 AND w<>11 then
            outLine=outLine & ";" & arrTable(w,q)
         end if
      next
      oLogFile.WriteLine outLine
      outLine=null
   next
end function


Function RetriveLDAPFormat(DottedName)
   Fields=Split(DottedName,".")
   OutString="dc=" & Fields(0)
   For q=1 to ubound(Fields)
      OutString=OutString & ",dc=" & Fields(q)
   next
   RetriveLDAPFormat=OutString
end function



